package mcfall.raytracer.objects;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import mcfall.math.IncompatibleMatrixException;
import mcfall.math.Matrix;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.math.Vector;
import mcfall.raytracer.Camera;

public abstract class AbstractRectangleExtent extends MathematicalObject implements ProjectedExtent {
	private Vector minRay,maxRay;
	int minCol,maxCol,minRow,maxRow;
	private Camera camera = null;
	private Set<Point> criticalPoints=null;
	public AbstractRectangleExtent() {
		super();
	}
	public AbstractRectangleExtent(String name) {
		super(name);
	}
	protected AbstractRectangleExtent(Camera camera, Set<Point> criticalPoints) {
		super();
		setUp(camera,criticalPoints);
	}
	protected void setUp() {
		if(criticalPoints!=null && camera!=null) {
			minCol=minRow=Integer.MAX_VALUE;//force the critical vectors to change these values
			maxCol=maxRow=Integer.MIN_VALUE;
			for(Point v : criticalPoints) {
				Vector temp;
				try {
					temp = camera.invertRayThrough(new Ray(camera.getLocation(),Point.fromColumnMatrix(this.getTransform().postmultiply(v))));
					minCol = (int)Math.floor(Math.max(0, Math.min(minCol, temp.getValueAt(1))));
					minRow = (int)Math.floor(Math.max(0, Math.min(minRow, temp.getValueAt(2))));
					maxCol = (int)Math.ceil(Math.min(camera.getPlaneWidth()-1, Math.max(maxCol, temp.getValueAt(1))));
					maxRow = (int)Math.ceil(Math.min(camera.getPlaneHeight()-1, Math.max(maxRow, temp.getValueAt(2))));
				} catch (IncompatibleMatrixException e) {
					e.printStackTrace();
				}
			}
			//TODO remove me
			System.out.println("("+minCol+","+minRow+")"+"("+maxCol+","+maxRow+")");
		}
	}
	public void setUp(Camera camera) {
		setUp(camera, criticalPoints);
	}
	public void setUp(Camera camera, Set<Point> criticalPoints) {
		this.camera=camera;
		this.criticalPoints=criticalPoints;
		setUp();
	}
	
	
	@Override
	public void transform(Matrix transform) {
		super.transform(transform);	
		setUp();
	}
	public boolean hits(int row, int column) {
		return (minCol<=column && column<=maxCol) && (minRow<=row && row<=maxRow);
	}
	public static AbstractRectangleExtent createRectangleExtent(Camera camera, Set<Point> criticalPoints) {
		return new AbstractRectangleExtent(camera,criticalPoints) {
			
			@Override
			protected List<HitRecord> genericHitTime(Ray ray) {
				return null;
			}
			@Override
			protected String getObjectType() {
				return null;
			}
			
		};
	}
	
}
